// priority: 16

// 1. 修改战利品表: e.modify("池子ID", 钓鱼 => { ... })
//    - "池子ID" 可以是 "treasure" (宝藏), "fish" (鱼), 或 "junk" (垃圾)。
//    - 这个方法会【修改】现有的战利品表，而不是完全替换它。
//
// 2. 添加原版掉落: L.addLootTable("原版表ID").weight(权重)
//    - 这是实现“追加”的核心技巧。我们将原版的整个掉落表
//      (例如 "minecraft:gameplay/fishing/treasure") 作为一个条目加回来。
//    - 通过调整它的权重，我们可以控制原版掉落和我们自定义掉落的整体比例。
//
// 3. 权重与概率计算:
//    - 在同一个掉落池里，某个物品被抽中的概率 = (该物品的权重) / (池子里所有物品的权重总和)。
//    - 例子：原版宝藏权重60，我们的宝箱权重8。总权重68。
//      那么钓到宝藏时，有 60/68 (~88%) 的概率获得一件原版宝藏，
//      有 8/68 (~12%) 的概率获得我们的宝箱。

ServerEvents.fishingLootTables(e => {
    // --- 1. 修改宝藏池 ("treasure") ---
    e.modify("treasure", 钓鱼 => {
        // 总权重: 30 + 10 + 30 + 4 + 10 = 84
        钓鱼.addPool(L => {
            L.rolls = 1;
            L.addLootTable("minecraft:gameplay/fishing/treasure").weight(30); // 原版宝藏整体 (概率 30/84 ≈ 35.7%)
            let 宝箱条目 = L.addItem("aquaculture:neptunes_bounty").weight(10); // 海王恩惠宝箱 (概率 10/84 ≈ 11.9%)
            宝箱条目.addFunction({
                "function": "minecraft:set_contents",
                "type": "aquaculture:neptunes_bounty",
                "entries": [{ "type": "minecraft:loot_table", "name": "aquaculture:box/neptunes_bounty" }]
            });
            let 金属粒条目 = L.addItem("aquaculture:neptunium_nugget").weight(30); // 海王粒 (概率 30/84 ≈ 35.7%)
            金属粒条目.addFunction({
                "function": "minecraft:set_count",
                "count": { "type": "minecraft:uniform", "min": 1, "max": 3 }
            });
            L.addItem("minecraft:heart_of_the_sea").weight(4); // 海洋之心 (概率 4/84 ≈ 4.8%)
            L.addItem(Item.of("minecraft:enchanted_book").enchant("minecraft:mending", 1)).weight(10); // 附魔书:经验修补 (概率 10/84 ≈ 11.9%)
        });
    });
    // --- 2. 修改鱼池 ("fish") ---
    e.modify("fish", 钓鱼 => {
        // 第一个池子：添加三种海龟，作为鱼池中的稀有掉落
        钓鱼.addPool(L => {
            L.rolls = 1;
            // 海龟的权重设置得较低，让它们成为不那么常见的收获
            // 总权重: 8 + 8 + 8 = 24
            L.addItem("aquaculture:box_turtle").weight(8);         // 箱龟 (概率 8/24 ≈ 33.3%)
            L.addItem("aquaculture:arrau_turtle").weight(8);      // 南美巨龟 (概率 8/24 ≈ 33.3%)
            L.addItem("aquaculture:starshell_turtle").weight(8);  // 星壳龟 (概率 8/24 ≈ 33.3%)
            // 为这个海龟池设置一个整体的触发概率，比如10%
            // 这样就不会过多影响钓到普通鱼的概率
            L.randomChance(0.10);
        });
        // 第二个池子：添加海王恩惠和海王粒作为惊喜掉落
        钓鱼.addPool(L => {
            L.rolls = 1;
            // 这个池子本身只有 5% 的几率被触发
            L.randomChance(0.05);
            // 如果触发了，下面的物品按权重随机选一个 (总权重: 5 + 2 = 7)
            L.addItem("aquaculture:neptunium_nugget").weight(5); // 海王粒 (最终概率 5% * (5/7) ≈ 3.57%)
            let 惊喜宝箱条目 = L.addItem("aquaculture:neptunes_bounty").weight(2); // 海王恩惠宝箱 (最终概率 5% * (2/7) ≈ 1.43%)
            惊喜宝箱条目.addFunction({
                "function": "minecraft:set_contents",
                "type": "aquaculture:neptunes_bounty",
                "entries": [{ "type": "minecraft:loot_table", "name": "aquaculture:box/neptunes_bounty" }]
            });
        });
    });
    // --- 3. 修改垃圾池 ("junk") ---
    e.modify("junk", 钓鱼 => {
        // 添加一个独立的“有价值的垃圾”池
        钓鱼.addPool(L => {
            L.rolls = 1;
            // 这个池子本身有 4% 的几率被触发
            L.randomChance(0.04);
            // 触发后，下面的物品按权重随机选一个 (总权重: 15 + 5 = 20)
            let 海王粒 = L.addItem("aquaculture:neptunium_nugget").weight(15); // 海王粒 (最终概率 4% * (15/20) = 3.0%)
            海王粒.addFunction({
                "function": "minecraft:set_count",
                "count": { "type": "minecraft:uniform", "min": 3, "max": 5 }
            });
            let 海王恩惠 = L.addItem("aquaculture:neptunes_bounty").weight(5); // 海王恩惠宝箱 (最终概率 4% * (5/20) = 1.0%)
            海王恩惠.name(Text.of("额外的奖励").yellow());
            海王恩惠.addFunction({
                "function": "minecraft:set_contents",
                "type": "aquaculture:neptunes_bounty",
                "entries": [{ "type": "minecraft:loot_table", "name": "aquaculture:box/neptunes_bounty" }]
            });
        });
    });
});